implementation module windowDevice;

import StdClass,StdInt, StdBool, StdChar;
import	pointer, structure, windows, quickdraw, events, controls, OS_utilities;
import	commonDef, windowInternal, windowAccess;
from	windowOpen		import OpenWindow;
from	deltaWindow		import CloseWindows;
from	deltaPicture	import ::Point;
from	timerDevice		import TimerFunctions;

import ScrollBars;

CleanWindowRefCon	:== 1;
WindowPtrRefCon		:== 152;

WindowFunctions :: DeviceFunctions *s;
WindowFunctions
	=	(ChangeAllWindowPtrs ShowWindow,
			OpenWindow,
				WindowIO,
			CloseWindow,
		 ChangeAllWindowPtrs HideWindow);


WindowIO :: !Event !*s !(IOState *s) -> (!Bool, !*s, !IOState *s);
WindowIO event=:(_,MouseDownEvent,_,_,h,v,_) s ioState
|	region - 3 >= 6		= (False, s, IOStateSetToolbox		tb1		ioState2);
|	not found			= (False, s, IOStateSetToolbox		tb1		ioState2);
|	region == InContent	= MouseInContent event	wH windows	tb1 s	ioState2;
|	region == InGoAway	= CheckGoAway			wH h v		tb1 s	ioState2;
|	region == InDrag	= (True, s,  IOStateSetToolbox		tbDrag	ioState2);
|	region == InGrow	= (True, s,  IOStateSetToolbox		tbGrow	ioGrow);
|	region == InZoomIn
||	region == InZoomOut	= (True, s,  IOStateSetToolbox		tbZoom	ioZoom);
						= (True, s,  IOStateSetToolbox		tb1		ioState2);
	where {
		tbDrag			= Drag_window (WindowGetPtr window) h v tb1;
		ioGrow			= IOStateSetWindow (wDef,grow) windows ioState2;
		(grow, tbGrow)	= Do_grow_window window (WindowDefGetMinimumSize wDef) h v tb1;
		ioZoom			= IOStateSetWindow (wDef,zoom) windows ioState2;
		(zoom, tbZoom)	= Zoom_window window h v region tb1;
		wH				= (wDef,window);
		(tb, ioState1)							= IOStateGetToolbox ioState;
		(region, wPtr, tb1)						= FindWindow h v tb;
		(found, wDef, window, windows,ioState2)	= LocateWindow wPtr ioState1;
	};
WindowIO (_,MouseUpEvent,_,_,h,v,mods) s ioState
|	not found			= (False, s,  IOStateSetToolbox tb1 ioState2);
|	not (Enabled ms)	= (True,  s,  IOStateSetToolbox tb1 ioState2);
						= (True,  s1, ioState3);
	where {
		(s1, ioState3)	= MouseIO window (h,v) mods ButtonUp mf tb1 s ioState2;
		(ms, mf)		= WindowDefGetMouse wDef;
		(found, wDef, window, windows, ioState2)
						= LocateWindow wPtr ioState1;
		(wPtr, tb1)		= FrontWindow tb;
		(tb, ioState1)	= IOStateGetToolbox ioState;
	};
WindowIO event=:(_,keyEvent,_,_,_,_,_) s ioState
|	keyEvent == KeyDownEvent
||	keyEvent == KeyUpEvent
||	keyEvent == AutoKeyEvent	= KeyboardIO event s ioState;
WindowIO (_,UpdateEvent,wPtr,_,_,_,_) s ioState
|	found		= (True,  s1, IOStateSetToolbox (EndUpdate wPtr tb4) ioUpdate);
				= (False, s,  IOStateSetToolbox (EndUpdate wPtr (BeginUpdate wPtr tb)) ioState2);
	where {
		(tb, ioState1)	= IOStateGetToolbox			ioState;
		(found, wDef, window, windows, ioState2)
						= LocateWindow wPtr			ioState1;
		(size,		tb1)= WindowGetFrameSize (wDef, window) tb;
		(updWindow,	tb2)= WindowSetUpdateArea rect window tb1;
		tb3				= BeginUpdate wPtr tb2;
		(window2,s1,tb4)= Draw_window updWindow [rect] mode f s tb3;
		ioUpdate		= IOStateSetWindow (wDef, window2) windows ioState2;
		f				= WindowDefGetUpdate	wDef;
		mode			= UpdateDrawMode		wDef;
		rect			= (0,0, width,height);
		(width, height)	= size;
	};
WindowIO (_,ActivateEvent,wPtr,_,_,_,mods) s ioState
|	not found			= (False, s,  ioState1);
|	activated			= (True,  sA, ioStateA);
						= (True,  sD, ioStateD);
	where {
		(sA, ioStateA)	= activateF	s (IOStateSelectWindow	(wDef, window) windows doActivation);
		(sD, ioStateD)	= deactivateF	s (IOStateSetWindow	(wDef, window) windows doActivation);
		activateF		= WindowDefGetActivate   wDef;
		deactivateF		= WindowDefGetDeactivate wDef;
		doActivation	= IOStateChangeToolbox display ioState1;
		display			= DisplayWindow (IsScrollWindow wDef) activated window;
		activated		= (mods bitand 1) <> 0;
		(found, wDef, window, windows, ioState1)	= LocateWindow wPtr ioState;
	};
WindowIO _ s ioState
	= (False, s, ioState);


CheckGoAway :: !(WindowHandle *s) !Int !Int !*Toolbox !*s !(IOState *s) -> (!Bool, !*s, !IOState *s);
CheckGoAway (wDef, window) h v tb s ioState
|	doGoAway	= (True, s1, ioState2);
				= (True, s,  ioState1);
	where {
		(s1, ioState2)	= goAway s ioState1;
		goAway			= WindowDefGetGoAway wDef;
		ioState1		= IOStateSetToolbox tb1 ioState;
		(doGoAway, tb1)	= TrackGoAway (WindowGetPtr window) h v tb;
	};


MouseIO :: !Window !Point !Int !ButtonState !(MouseFunction *s (IOState *s)) !*Toolbox !*s !(IOState *s)
	->	(!*s, ! IOState *s);
MouseIO (wPtr,(hControl,_,h_max),(vControl,_,v_max),_,_,_) globPos mods buttonState mouseIO tb s ioState
	= 	mouseIO mouseState s (IOStateSetToolbox tb3 ioState);
	where {
		mouseState		= ((h2+hThumb, v2+vThumb), buttonState, INTToModifiers mods);
		(h2,v2)			= local;
		(local,  tb3)	= InGrafport wPtr (GlobalToLocal globPos) tb2;
		(hThumb, tb1)	= GetScrollBarValue hControl h_max tb;
		(vThumb, tb2)	= GetScrollBarValue vControl v_max tb1;
	};


KeyboardIO :: !Event !*s !(IOState *s) -> (!Bool, !*s, !IOState *s);
KeyboardIO (_,keyEvent,message,_,_,_,mods) s ioState
|	not found			= (False, s,  ioState2);
|	not (Enabled ks)	= (True,  s , ioState2);
						= (True,  s1, ioState3);
	where {
		(wPtr,ioState1)	= IOStateAccessToolbox FrontWindow ioState;
		(found, wDef, window, windows, ioState2)
						= LocateWindow wPtr ioState1;
		(ks, kf)		= WindowDefGetKeyboard wDef;
		keyState		= (toChar (message bitand 255), EventToKeyState keyEvent, INTToModifiers mods);
		(s1, ioState3)	= kf keyState s ioState2;
	};

EventToKeyState :: !Int -> KeyState;
EventToKeyState KeyDownEvent	= KeyDown;
EventToKeyState KeyUpEvent		= KeyUp;
EventToKeyState AutoKeyEvent	= KeyStillDown;


LocateWindow :: !WindowPtr !(IOState s)
	-> (	!Bool,
			!WindowDef s (IOState s),
			!Window,
			!DeviceSystemState s,
			!IOState s
		);
LocateWindow wPtr ioState
	= 	(found, wDef, window, windows, ioState1);
	where {
		(wDef,	window)		= wH;
		(found,	wH)			= Select (EqualWindowHandlePtr wPtr) (DummyWindowHandle wPtr) wHs;
		(wHs, cursor)		= WindowSystemState_WindowHandles windows;
		(windows,ioState1)	= IOStateGetDevice ioState WindowDevice;
	};

Select :: !(Cond x) x ![x] -> (!Bool, x);
Select c n [x : xs]
	| c x		= (True, x);
				= Select c n xs;
Select _ n _ = (False, n);

EqualWindowHandlePtr :: !WindowPtr !(WindowHandle s) -> Bool;
EqualWindowHandlePtr wPtr wHandle = wPtr == WindowHandleGetPtr wHandle;

DisplayWindow :: !Bool !Bool !Window !*Toolbox -> *Toolbox;
DisplayWindow False _ _ tb = tb;
DisplayWindow documentWindow show (wPtr,(hControl,_,_),(vControl,_,_),_,_,_) tb
|	show	= ShowControl vControl (ShowControl hControl tb1);
			= HideControl vControl (HideControl hControl tb1);
	where {
		tb1 = DrawGrowIcon wPtr tb;
	};

WindowGetScroll_and_Page :: !ControlHandle !Window !(!Int, !Int) -> (!Int,!Int,!Int);
WindowGetScroll_and_Page control (_,(hControl,hScroll,h_max),(_,vScroll,v_max),_,_,_) (windowW, windowH)
	| control == hControl
		= (hScroll, dHpage - dHpage mod hScroll,h_max);
		= (vScroll, dVpage - dVpage mod vScroll,v_max);
	where {
		dHpage = windowW - hScroll;
		dVpage = windowH - vScroll;
	};

MouseInContent :: !Event !(WindowHandle *s) !(DeviceSystemState *s) !*Toolbox !*s !(IOState *s)
	->	(!Bool, !*s, !IOState *s);
MouseInContent event=:(b, mouseDown,mess,time,h,v,mods) w_and_h=:(wDef,window) ws tb s ioState
|	notFront
&&	WindowDefIsStandBy wDef		= WindowIO event s select;
|	notFront					= (True, s, select);
|	part == InUpButton			= (True, sHiUp,	IOStateSetToolbox tbHiUp	ioHiUp);
|	part == InDownButton		= (True, sHiDo,	IOStateSetToolbox tbHiDo	ioHiDo);
|	part == InPageUp			= (True, sUp,	IOStateSetToolbox tbUp		ioUp);
|	part == InPageDown			= (True, sDo,	IOStateSetToolbox tbDo		ioDo);
|	part == InThumb				= (True, sThumb,IOStateSetToolbox tbThumb	ioThumb);
|	h2 >= width || v2 >= height	= (True, s,		IOStateSetToolbox tb4		ioState);
|	Enabled ms					= (True, s2,	IOStateSetToolbox tb6		ioState5);
								= (True, s,		IOStateSetToolbox tb4		ioState);
	where {
		wPtr					= WindowGetPtr window;
		(frontPtr, tb1)			= FrontWindow tb;
		(local, tb2)			= InGrafport wPtr (GlobalToLocal (h,v)) tb1;
		(h2, v2)				= local;
		(part, control, tb3)	= FindControl h2 v2 wPtr tb2;
		select					= IOStateSetToolbox (SelectWindow wPtr tb1) ioState;
		(size, tb4)				= WindowGetFrameSize w_and_h tb3;
		(width, height)			= size;
		(dScroll,dPage,control_max) = WindowGetScroll_and_Page control window size;
		f						= WindowDefGetUpdate wDef;
		(hiUp, sHiUp, tbHiUp)	= DoHilitControl control window part (decControl dScroll control control_max) f s tb4;
		(hiDo, sHiDo, tbHiDo)	= DoHilitControl control window part (incControl dScroll control control_max) f s tb4;
		(up,	 sUp, tbUp)		= DoControl		 control window part (decControl dPage   control control_max) f s tb4;
		(down, sDo,	  tbDo)		= DoControl		 control window part (incControl dPage   control control_max) f s tb4;
		(thumb,sThumb,tbThumb)	= MoveThumb control window h2 v2 f s tb4;
		ioHiUp					= IOStateSetWindow (wDef, hiUp) ws ioState;
		ioHiDo					= IOStateSetWindow (wDef, hiDo) ws ioState;
		ioUp					= IOStateSetWindow (wDef, up)	ws ioState;
		ioDo					= IOStateSetWindow (wDef, down)	ws ioState;
		ioThumb					= IOStateSetWindow (wDef,thumb)	ws ioState;
		(tb6, s2, ioState5)		= TrackMouseStillDown wPtr timerIO tb5 s1 ioState4;
		(tb5, ioState4)			= IOStateGetToolbox ioState3;
		(_,_,timerIO,_,_)		= TimerFunctions;
		(s1, ioState3)			= MouseIO window (h,v) mods button mf tb4 s ioState2;
		(button,ioState2)		= IOStateButtonFreq time (h2, v2) wPtr ioState;
		(ms, mf)				= mouse;
		mouse					= WindowDefGetMouse wDef;
		notFront				= wPtr <> frontPtr;
	};


TrackMouseStillDown :: !WindowPtr !(DoIOFunction *s) !*Toolbox !*s !(IOState *s)
	->	(!*Toolbox, !*s, ! IOState *s);
TrackMouseStillDown frontWindow timerIO tb s ioState
|	frontWindow <> frontPtr	= (tb1, s, ioState)
|	not found				= (tb2, s, ioState1)
|	not (Enabled ms)		= (tb2, s, ioState1)
|	timer					= (tb3, s1,ioState3)
|	not mouseDown			= (tb4, s1,ioState3)
							= TrackMouseStillDown frontWindow timerIO tb9 s2 ioState5;
	where {
		(frontPtr,tb1)	= FrontWindow tb;
		(time,	  tb2)	= TickCount tb1;
		(found, wDef, window, windows, ioState1)
						= LocateWindow frontWindow ioState;
		(timer, s1, ioState2)
						= timerIO event` s (IOStateSetToolbox tb2 ioState1);
		event`			= (True, NullEvent, 0, time, 0, 0, 0);
		mouse			= WindowDefGetMouse wDef;
		(ms, mf)		= mouse;
		(tb3, ioState3)	= IOStateGetToolbox ioState2;
		(mouseDown,tb4)	= StillDown tb3;
		(s2,  ioState4)	= mf mouseState s1 (IOStateSetToolbox tb8 ioState3);
		(tb9, ioState5)	= IOStateGetToolbox ioState4;
		mouseState		= ((h + hThumb,v + vThumb), ButtonStillDown, KeyMapToModifiers (k1,k2,k3,k4));
		(mousePos, tb5)	= InGrafport frontWindow GetMousePosition tb4;
		(h, v)			= mousePos;
		(hThumb, tb6)		= GetScrollBarValue hControl hMax tb5;
		(vThumb, tb7)		= GetScrollBarValue vControl vMax tb6;
		(hControl, _, hMax)			= hBar;
		(vControl, _, vMax)			= vBar;
		(_,hBar,vBar,_,_,_)	= window;
		(k1,k2,k3,k4,tb8)					= GetKeys tb7;
	};


GetMousePosition :: !*Toolbox -> (!Point, !*Toolbox);
GetMousePosition tb
	= 	((x,y),tb1);
	where {
		(x, y, tb1) = GetMouse tb;
	};


TrackMouseWhileDown :: !*Toolbox -> *Toolbox;
TrackMouseWhileDown tb
|	stillDown	= TrackMouseWhileDown tb1;
				= tb1;
	where {
		(stillDown, tb1) = WaitMouseUp tb;
	};

incControl :: !Int !ControlHandle !Int !*Toolbox -> *Toolbox;
incControl delta control max2 tb
	| nv > max		= SetScrollBarValue control max max2 tb2;
					= SetScrollBarValue control nv max2 tb2;
	where {
		(v,	tb1)	= GetScrollBarValue	control max2 tb;
		(max, tb2)	= GetScrollBarMax control max2 tb1;
		nv			= v + delta;
	};

decControl :: !Int !ControlHandle !Int !*Toolbox -> *Toolbox;
decControl delta control max2 tb
	| nv < min				= SetScrollBarValue control min max2 tb2;
	| v == max && 0 <> mod_v= SetScrollBarValue control (v - mod_v) max2 tb3;
							= SetScrollBarValue control nv max2 tb3;
	where {
		(v,	  tb1)	= GetScrollBarValue control max2 tb;
		(min, tb2)	= GetScrollBarMin control max2 tb1;
		(max, tb3)	= GetScrollBarMax control max2 tb2;
		mod_v		= (v - min) mod delta;
		nv			= v - delta;
	};

WindowSetThumbs :: !Window !Int !Int !Int !Int !(!Int, !Int) !(UpdateFunction *s) !*s !*Toolbox
	->	(!Window, !*s, !*Toolbox);
WindowSetThumbs window=:(wPtr,hBar,vBar,pict,updArea,zoom) tH tV oldtH oldtV (w, h) f s tb
	| WindowGetPtr window == frontPtr
		= Scroll_window window1 oldtH oldtV tH tV f s1 (Set_thumbs window1 tH tV tb2);
		= UpdateWindow (wPtr,hBar,vBar,pict,updArea,zoom) rect f s [((0,0),(w,h))]
			(Set_thumbs window tH tV tb1);
	where {
		(frontPtr,	  tb1)	= FrontWindow tb;
		(window1, s1, tb2)	= UpdateWindow window rect f s updArea tb1;
		rect				= (0,0, w,h);
		updArea				= [((tH,tV),(tH+w,tV+h))];
	};

UpdateWindow :: !Window !Rect !(UpdateFunction *s) !*s !UpdateArea !*Toolbox
	->	(!Window, !*s, !*Toolbox);
UpdateWindow window=:(wPtr,_,_,_,_,_) rect f s upd tb
	= 	(window2, s2, EndUpdate wPtr tb4);
	where {
		(window2, s2, tb4)	= Draw_window window1 [rect] HasControls f s tb3;
		(window1,	  tb3)	= WindowSetUpdateArea rect window tb2;
		tb2					= BeginUpdate wPtr tb1;
		tb1					= Update_window upd wPtr tb;
	};

Set_thumbs :: !Window !Int !Int !*Toolbox -> *Toolbox;
Set_thumbs (_,(hControl,_,h_max),(vControl,_,v_max),_,_,_) hThumb vThumb tb
	=	SetScrollBarValue vControl vThumb v_max (SetScrollBarValue hControl hThumb h_max tb);


//	Getting the current cursor shape and content:

IOStateGetCursorPos :: !(IOState s) -> (!Bool, !Bool, !WindowPtr, !IOState s);
IOStateGetCursorPos ioState
|	wPtr<>0		= (global, inContent, wPtr, IOStateSetToolbox tb4 ioState2);
					with {
						(locMousePos, tb2)		= InGrafport wPtr GetMousePosition tb1;
						(globMousePos,tb3)		= InGrafport wPtr (LocalToGlobal locMousePos) tb2;
						(global,inContent,tb4)	= WindowsGetCursorPos wPtr globMousePos windows tb3;
					};
				= (global, False, wPtr, IOStateSetToolbox tb1 ioState2);
					with {
						global	= (\(WindowSystemState (_,gCursor))->IsGlobalCursorSet gCursor) windows;
					};
	where {
		(windows, ioState1)		= IOStateGetDevice ioState WindowDevice;
		(tb, ioState2)			= IOStateGetToolbox ioState1;
		(wPtr, tb1)				= FrontWindow tb;
	};

WindowsGetCursorPos	:: !WindowPtr !Point !(DeviceSystemState s) !*Toolbox -> (!Bool, !Bool, !*Toolbox);
WindowsGetCursorPos wPtr (x,y) (WindowSystemState ([wH : wHs], gCursor)) tb
|	wPtr <> (WindowHandleGetPtr wH)	= (IsGlobalCursorSet gCursor, False,	tb );
									= (IsGlobalCursorSet gCursor, inContent,tb2);
	where {
		inContent		= IsBetween x l (l+w) && IsBetween y t (t+h);
		(size,   tb1)	= WindowGetFrameSize wH tb;
		(corner, tb2)	= InGrafport wPtr (LocalToGlobal (0,0)) tb1;
		(w,h)			= size;
		(l,t)			= corner;
	};
WindowsGetCursorPos _ _ (WindowSystemState (_,gCursor)) tb
	= 	(IsGlobalCursorSet gCursor, False, tb);

IOStateGetLocalCursor :: !(IOState s) -> (!CursorShape, !IOState s);
IOStateGetLocalCursor ioState
	=	(WindowsGetLocalCursor windows, ioState1);
	where {
		(windows, ioState1) = IOStateGetDevice ioState WindowDevice;
	};

IOStateGetGlobalCursor :: !(IOState s) -> (!CursorShape, !IOState s);
IOStateGetGlobalCursor ioState
	=	(WindowsGetGlobalCursor windows, ioState1);
	where {
		(windows, ioState1) = IOStateGetDevice ioState WindowDevice;
	};

WindowsGetLocalCursor :: !(DeviceSystemState s) -> CursorShape;
WindowsGetLocalCursor (WindowSystemState ([(wDef,_) : _],_))	= WindowDefGetCursor wDef;
WindowsGetLocalCursor _											= StandardCursor;

WindowsGetGlobalCursor :: !(DeviceSystemState s) -> CursorShape;
WindowsGetGlobalCursor (WindowSystemState (_,GlobalCursorSet cShape))	= cShape;
WindowsGetGlobalCursor _												= StandardCursor;

IsGlobalCursorSet :: !GlobalCursor  -> Bool;
IsGlobalCursorSet NoGlobalCursor	= False;
IsGlobalCursorSet _					= True;


//	Set the cursor shape.


IBeamC	:== 1;
CrossC	:== 2;
PlusC	:== 3;
WatchC	:== 4;

IOStateSetCursorShape :: !CursorShape !(IOState s) -> IOState s;
IOStateSetCursorShape StandardCursor ioState = IOStateChangeToolbox  QInitCursor			 ioState;
IOStateSetCursorShape BusyCursor     ioState = IOStateChangeToolbox (QSetCursorShape WatchC) ioState;
IOStateSetCursorShape IBeamCursor    ioState = IOStateChangeToolbox (QSetCursorShape IBeamC) ioState;
IOStateSetCursorShape CrossCursor    ioState = IOStateChangeToolbox (QSetCursorShape CrossC) ioState;
IOStateSetCursorShape FatCrossCursor ioState = IOStateChangeToolbox (QSetCursorShape PlusC ) ioState;
IOStateSetCursorShape HiddenCursor   ioState = IOStateChangeToolbox  QHideCursor			 ioState;
IOStateSetCursorShape other_cursor   ioState = IOStateChangeToolbox  QInitCursor			 ioState;

QSetCursorShape	:: !Int !*Toolbox -> *Toolbox;
QSetCursorShape cursorId tb
	=	tb4
	where {
		(cursorH,tb1)	= GetCursor cursorId tb;
		(cShape, tb2)	= LoadLong cursorH tb1;
		tb3				= QSetCursor cShape tb2;
		tb4				= QShowCursor tb3;
	};


//	Access-rules.

IOStateSelectWindow :: !(WindowHandle s) !(DeviceSystemState s) !(IOState s) -> IOState s;
IOStateSelectWindow wH windowSystemState ioState
	#	(wHs, cursor)	= WindowSystemState_WindowHandles windowSystemState;
	#	wPtr			= WindowHandleGetPtr wH;
	#	(_,_,wHs1)		= Remove (EqualWindowHandlePtr wPtr) wH wHs;
	#!  wHs1=wHs1;
	= IOStateSetDevice ioState (WindowSystemState ([wH : wHs1], cursor));

IOStateSetWindow :: !(WindowHandle s) !(DeviceSystemState s) !(IOState s) -> IOState s;
IOStateSetWindow wH windowSystemState ioState
	# wPtr			= WindowHandleGetPtr wH;
	# (wHs, cursor)	= WindowSystemState_WindowHandles windowSystemState;
	# (_,wHs1)		= Replace (EqualWindowHandlePtr wPtr) wH wHs;
	#! wHs1=wHs1;
	= IOStateSetDevice ioState (WindowSystemState (wHs1, cursor));

Replace :: !(Cond x) x ![x] -> (!Bool, ![x]);
Replace c y [x : xs]
|	c x		= (True, [y : xs]);
			= (b, [x : xs`]);
	where {
		(b, xs`) = Replace c y xs;
	};
Replace _ _ xs = (False, xs);
